unit fROR_DateTimeSelector;
{
================================================================================
*
*	Application:  Vitals
*	Revision:     $Revision: 5 $  $Modtime: 3/07/07 3:40p $
*	Developer:                       @domain.ext
*	Site:         Hines OIFO
*
*	Description:  Date/Time Selection Dialog
*
*	Notes:        
*
================================================================================
*       $Archive: /CCR v1.5/Current/fROR_DateTimeSelector.pas $
*
* $History: fROR_DateTimeSelector.pas $
 * 
 * *****************  Version 5  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 4  *****************
 * User: Vhaishgavris Date: 1/10/05    Time: 3:48p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 3  *****************
 * User: Vhaishgavris Date: 10/15/04   Time: 10:17a
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 2  *****************
 * User: Vhaishgavris Date: 10/14/04   Time: 3:50p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 1  *****************
 * User: Vhaishgavris Date: 9/11/03    Time: 5:03p
 * Created in $/ICR v3.0/Current
 * 
 * *****************  Version 2  *****************
 * User: Vhaishandria Date: 8/01/03    Time: 9:48a
 * Updated in $/ICR v3.0/Current
 * Build 63
 * 
 * *****************  Version 1  *****************
 * User: Vhaishandria Date: 7/31/03    Time: 12:41p
 * Created in $/ICR v3.0/Current
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ExtCtrls;

type
  TfrmDTSelector = class(TForm)
    Panel1: TPanel;
    grpBoxDT: TGroupBox;
    Panel2: TPanel;
    pnlDate: TPanel;
    Panel5: TPanel;
    bbtnToday: TBitBtn;
    mncCalendar: TMonthCalendar;
    Panel6: TPanel;
    lbxHours: TListBox;
    lbxMinutes: TListBox;
    Panel4: TPanel;
    bbtnMidnight: TBitBtn;
    bbtnNow: TBitBtn;
    SpeedButton2: TSpeedButton;
    SpeedButton1: TSpeedButton;
    edtTime: TEdit;
    pnlDateTimeText: TPanel;
    Label1: TLabel;
    bbtnYesterday: TBitBtn;
    bbtnTomorrow: TBitBtn;
    Timer1: TTimer;
    Label2: TLabel;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure lbxHoursClick(Sender: TObject);
    procedure lbxMinutesClick(Sender: TObject);
    procedure edtTimeKeyPress(Sender: TObject; var Key: Char);
    procedure bbtnNowClick(Sender: TObject);
    procedure bbtnMidnightClick(Sender: TObject);
    procedure bbtnTodayClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure edtTimeChange(Sender: TObject);
    procedure mncCalendarClick(Sender: TObject);
    procedure SetDateTimeText;
    procedure UpdateText;
    procedure bbtnYesterdayClick(Sender: TObject);
    procedure bbtnTomorrowClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    dltTime: TDateTime;
    procedure SetDateTime;
    function TimeIsValid(h,m:Integer):Boolean;
    procedure SetButtonState;
    procedure SetCalendarLimits(Past:Boolean; aNow: TDateTime);
  public
    { Public declarations }
  end;

var
  frmDTSelector: TfrmDTSelector;

implementation

{$R *.DFM}
uses
   uROR_Utilities, uROR_CommonUtils, uROR_Broker, uROR_Common;

const
  DTRoutine = 'ROR GET SERVER TIME'; // ICR3

procedure TfrmDTSelector.FormCreate(Sender: TObject);
var
  aNow: TDateTime;
begin
  aNow := Now;
  Broker.CallProc(DTRoutine, []);
  try
    dltTime := aNow - FMDateTimeToWindowsDateTime(StrToFloat(Broker.Results[1]));

    aNow :=  FMDateTimeToWindowsDateTime(StrToFloat(Broker.Results[1]));
  except
    on E: EConvertError do
      MessageDlg508('', 'Unable to set client to the servers time.', mtWarning, [mbok], 0);
  else
    raise
  end;

//  grpBoxDT.Caption := '';

  SetCalendarLimits(False,aNow);//False -- to limit the Past
  edtTime.Text := FormatDateTime('hh:mm:ss',aNow);
end;

procedure TfrmDTSelector.SetCalendarLimits(Past:Boolean; aNow: TDateTime);
begin
  try
    if Past then
      begin
        mncCalendar.MaxDate := aNow;
        mncCalendar.Date :=   mncCalendar.MaxDate;
        caption := 'Select Date & Time up to ' +FormatDateTime('mm/dd/yyyy hh:mm',mncCalendar.MaxDate);
      end
    else
      begin
        mncCalendar.MinDate := Trunc(aNow);
        mncCalendar.MaxDate := mncCalendar.MinDate + 100;
        mncCalendar.Date :=   aNow + 0.01;
        caption := 'Select Date & Time starting from ' +FormatDateTime('mm/dd/yyyy hh:mm',mncCalendar.MinDate);
      end;
  except
  end;
end;

procedure TfrmDTSelector.SetDateTime;
var
  S: String;
  i,j: Integer;
begin
  try
    i := StrToInt(lbxHours.Items[lbxHours.ItemIndex]);
  except
    i := 0;
  end;

  try
    S := lbxMinutes.Items[lbxMinutes.ItemIndex];
    while (pos('0',S) = 1) or (pos(':',S)=1) do
      S := copy(s,2,Length(S)-1);
    if pos(' --',S)=1 then
      j := 0
    else
      j := StrToInt(Piece(S,' ',1));
  except
    j := 0;
  end;
  if TimeIsValid(i,j) then
      edtTime.Text := Format('%2.2d:%2.2d',[i,j])
  else
    begin
{
      if mncCalendar.MinDate > 0 then
        MessageDlg508('', 'Sorry, you can not select a future date or time'+#13+#13+
                'or time prior to '+FormatDateTime('mm/dd/yy hh:mm:ss',trunc(mncCalendar.MinDate)+1),
                 mtError, [mbOk], 0)
      else
        MessageDlg508('', 'Sorry, you can not select a future date or time',
                 mtError, [mbOk], 0);
}
        MessageDlg508('', 'Sorry, you can not select a past date or time', mtError, [mbOk], 0);
    end;
  SetDateTimeText;
end;

procedure TfrmDTSelector.lbxHoursClick(Sender: TObject);
begin
  SetDateTime;
end;

procedure TfrmDTSelector.lbxMinutesClick(Sender: TObject);
begin
  SetDateTime;
end;

procedure TfrmDTSelector.edtTimeKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    begin
      try
        UpdateText;
      except
        MessageDlg508('', 'Invalid time string.', mtError,[mbOk], 0);
        activecontrol := edtTime;
      end;
    end;
end;

procedure TfrmDTSelector.UpdateText;
begin
    begin
      try
        SetDateTimeText;
      except
        MessageDlg508('', 'Check time value!',mtError,[mbYes,mbCancel],0 );
      end;
    end;
end;

procedure TfrmDTSelector.bbtnNowClick(Sender: TObject);
var
  aNow: TDateTime;
begin
  aNow := Now - dltTime;
  SetCalendarLimits(False,aNow);

  edtTime.Text := FormatDateTime('hh:mm:ss',aNow);

  SetButtonState;
  updateText;
  try
    lbxHours.ItemIndex := -1;
    lbxMinutes.ItemIndex := -1;
  except
  end;
end;

procedure TfrmDTSelector.bbtnMidnightClick(Sender: TObject);
begin
  edtTime.Text := FormatDateTime('hh:mm',0);
  updateText;
  try
    lbxHours.ItemIndex := -1;
    lbxMinutes.ItemIndex := -1;
  except
  end;
end;

procedure TfrmDTSelector.bbtnTodayClick(Sender: TObject);
begin
  bbtnNowClick(sender);
{
  mncCalendar.minDate := Now-dltTime;
  mncCalendar.Date := mncCalendar.minDate+ abs(dltTime);
  SetDateTimeText;
  bbtnTomorrow.Enabled := False;
}
end;

procedure TfrmDTSelector.SpeedButton1Click(Sender: TObject);
var
  T:TDateTime;
begin
  try
    T := StrToTime(edtTime.Text);
    if (T+trunc(mncCalendar.Date))- mncCalendar.MinDate > 0  then
      ModalResult := mrOK
    else
        MessageDlg508('', 'Sorry, you can not select a past date or time', //AAN 10/30/2002
                 mtError, [mbOk], 0);                                 //AAN 10/30/2002
{
    if (T+trunc(mncCalendar.Date))-mncCalendar.MaxDate < 2/24/3600  then
      ModalResult := mrOK
    else
        MessageDlg508('', 'Sorry, you can not select a future date or time', //AAN 10/30/2002
                 mtError, [mbOk], 0);                                 //AAN 10/30/2002
}
  except
    MessageDlg508('', 'Invalid time string.', mtError, [mbOk], 0);
    activecontrol := edtTime;
  end;
end;

procedure TfrmDTSelector.SpeedButton2Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfrmDTSelector.edtTimeChange(Sender: TObject);
begin
  SetDateTimeText;
end;

procedure TfrmDTSelector.SetDateTimeText;
begin
  pnlDateTimeText.Caption := FormatDateTime('    mm/dd/yy ',mncCalendar.Date)+edtTime.Text;
end;

procedure TfrmDTSelector.mncCalendarClick(Sender: TObject);
begin
  SetDateTimeText;
  SetButtonState;
end;

function TfrmDTSelector.TimeIsValid(h,m:Integer):boolean;
begin
  result :=
    ( trunc(mncCalendar.Date) + h/24+m/24/60 < mncCalendar.MaxDate)
    and
    (mncCalendar.MinDate < trunc(mncCalendar.Date) + h/24+m/24/60);
end;

procedure TfrmDTSelector.bbtnYesterdayClick(Sender: TObject);
begin
  try
    if mncCalendar.Date - 1 > mncCalendar.MinDate then
      begin
        mncCalendar.Date := mncCalendar.Date - 1;
        UpdateText;
        SetButtonState;
      end
    else
      bbtnNowClick(Sender);
  except
  end;
end;

procedure TfrmDTSelector.bbtnTomorrowClick(Sender: TObject);
begin
  try
    mncCalendar.Date := mncCalendar.Date + 1;
    UpdateText;
    SetButtonState;
  except
  end;
end;

procedure TfrmDTSelector.SetButtonState;
begin
    if trunc(mncCalendar.Date) = trunc(mncCalendar.MaxDate) then
       bbtnTomorrow.Enabled := False
    else
       bbtnTomorrow.Enabled := True;
    if trunc(mncCalendar.Date) = trunc(mncCalendar.MinDate) then
       bbtnYesterday.Enabled := False
    else
       bbtnYesterday.Enabled := True;
end;

procedure TfrmDTSelector.FormActivate(Sender: TObject);
begin
  updateText;
  SetButtonState;
end;

procedure TfrmDTSelector.Timer1Timer(Sender: TObject);
var
  aNow: TDateTime;
begin
  try
    aNow := Now - dltTime;
    label2.Caption := FormatDateTime('mm/dd/yyyy hh:mm:ss',aNow);
    mncCalendar.MinDate := aNow;
  except
  end;
end;

end.

